$(document).ready(async function () {

    $('#btnFiltros').on('click', async function () {    // Da um click em cada select ao abrir o modal, 
        $('#modal-filtros').modal('show');
    });

    let dataAte = '';

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    componenteFiltro('material', true);
    componenteFiltro('grupoMA', true);
    componenteFiltro('vendedor', true);
    componenteFiltro('grupoCli', true);
    componenteFiltro('entidade', true);
    componenteFiltro('produto', true);
    componenteFiltro('cor', true);
    componenteFiltro('grupoPA', true);
    componenteFiltro('colecao', true);
    componenteFiltro('etiqueta', true);
    componenteFiltro('linha', true);
    componenteFiltro('marca', true);
    componenteFiltro('modelo', true);
    componenteFiltro('tipoVenda', true);
    limparFiltros(true);

    preencheOrdenacaoTela('TotalPorAno');

    $('#rdProduto, #rdMaterial').on('change', function () {

        $('#txtEntidade').empty().trigger('change');
        $('#txtVendedor').empty().trigger('change');
        $('#txtGrupoCli').empty().trigger('change');
        $('#txtProduto').empty().trigger('change');
        $('#txtMaterial').empty().trigger('change');
        $('#txtCor').empty().trigger('change');
        $('#txtColecao').empty().trigger('change');
        $('#txtGrupoPA').empty().trigger('change');
        $('#txtEtiqueta').empty().trigger('change');
        $('#txtLinha').empty().trigger('change');
        $('#txtMarca').empty().trigger('change');
        $('#txtModelo').empty().trigger('change');

        if ($('#rdMaterial').is(':checked')) {
            $('#ProdutoInfoTour, #CorInfoTour, #GrupoProdInfoTour, #ModeloInfoTour').addClass('d-none')
            $('#MaterialInfoTour, #GrupoMAInfoTour').removeClass('d-none')
        }
        else {
            $('#ProdutoInfoTour, #CorInfoTour, #GrupoProdInfoTour, #ModeloInfoTour').removeClass('d-none')
            $('#MaterialInfoTour, #GrupoMAInfoTour').addClass('d-none')
        }
    });


    if (colunas == null || colunas.totalporano == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, totalporano: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, totalporano: novasColunas }))

            $('#tabelaTotalPorAno').DataTable().columns().visible(true);

            $('#tabelaTotalPorAno').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#txtPeriodoDe').on('blur', async function () {
        let dataDe = new Date($(this).val() + ' 00:00:00');

        if (dataDe == 'Invalid Date') {
            msgAlerta('Você precisa informar um período de para depois informar um período até, favor verificar!');
            return;
        };

        $('#txtPeriodoAte').prop('disabled', false);
        //aqui começo a calcular pra trazer a data maxima do filtro corretamente
        dataDe.setMonth(dataDe.getMonth());
        dataDe.setDate(0);
        dataDe.setFullYear(dataDe.getFullYear() + 1);

        const dia = dataDe.getDate();
        const mes = dataDe.getMonth() + 1;
        const ano = dataDe.getFullYear();

        const dataAteFormatada = `${ano}-${mes.toString().padStart(2, '0')}-${dia.toString().padStart(2, '0')}`;
        dataAte = dataAteFormatada;

        $('#txtPeriodoAte').val(dataAteFormatada);
    });

    $('#txtPeriodoAte').on('blur', async function () {
        const dataAteInformada = new Date($(this).val() + ' 00:00:00');
        const dataAteAntiga = new Date(dataAte + ' 00:00:00');

        if (dataAteInformada == 'Invalid Date') {
            msgAlerta('Favor informar um período de - até para continuar!');
            $('#txtPeriodoDe').val('');
            $('#txtPeriodoAte').val('');
            return;
        };

        if (dataAteInformada > dataAteAntiga) {
            msgAlerta('Impossível filtrar mais que o período de um ano! Favor verificar.');
            $('#txtPeriodoDe').val('');
            $('#txtPeriodoAte').val('');
            return;
        };
    });

    let chart = null;
    $('#btnConsultar').on('click', async function () {
        $('#chart').removeClass('d-none');
        try {
            $.LoadingOverlay('show');
            if ($("#txtOrdem option").toArray().length > 0) {
                retornaHintRelatorio('btnImprimir', $('#txtOrdem option').toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
            }
            try {
                if ($.fn.DataTable.isDataTable('#tabelaTotalPorAno')) {
                    $('#tabelaTotalPorAno').DataTable().destroy();
                    $('#tabelaTotalPorAno').empty();
                };

                Graficos.limpaGrafico(['graficoRelTotalPorAno']);

                let dataSetCols = [];
                const params = await retornaFiltros();
                const url = '/sisplan/impressao/v1/totalporano?';

                if (new Date($('#txtPeriodoAte').val() + ' 00:00:00') > new Date(dataAte + ' 00:00:00')) {
                    msgAlerta('Impossível filtrar mais que o período de um ano! Favor verificar.');
                    $('#txtPeriodoDe').val('');
                    $('#txtPeriodoAte').val('');
                    return;
                };

                const response = await requisicao('GET', url, params, null, 60000);

                if (!response) {
                    return;
                };

                const jsonStr = await response.json();

                if (jsonStr.length == 0) {
                    msgAlerta('Nenhum registro encontrado!');
                    $('#chart').empty();
                    $('#chart').addClass('d-none');
                    chart.destroy();
                    return;
                }

                if (response.status != 200) {
                    console.error(jsonStr.mensagem);
                    return;
                }

                const keys = jsonStr.map((key) => {
                    return { ...key, MES: `${retornaNomeMes(key.MES)}`, VALOR: `<b>${parseFloat(key.VALOR).toLocaleString("pt-br", { style: "currency", currency: "BRL", }).replace('R$', '')}</b>`, QTDE: `<b>${key.QTDE}</b>`, QTDE_VEN: `<b>${key.QTDE_VEN}</b>`, }
                })

                Object.keys(jsonStr[0]).forEach(k => {
                    k = { data: k, title: k }

                    switch (k.data) {
                        case 'MES':
                            k.title = 'MÊS'
                            break;
                        case 'QTDE':
                            k.title = 'QUANTIDADE'
                            break;
                        case 'QTDE_VEN':
                            k.title = 'QUANTIDADE VENDAS'
                            break;
                        default:
                            break;
                    }

                    dataSetCols.push({
                        'title': k.title,
                        'data': k.data
                    });

                });

                $('#tabelaTotalPorAno').DataTable({
                    destroy: true,
                    autoWidth: true,
                    "colReorder": true,
                    "data": keys,
                    "columns": dataSetCols,
                    "columnDefs": [
                        {
                            targets: colunas.totalporano ?? [],
                            visible: false,
                        },
                        {
                            className: 'text-right',
                            targets: [3, 4, 5, 6, 7]
                        },
                        {
                            className: 'text-center',
                            targets: [1, 2]
                        },
                    ],
                });

                const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));


                // adiciona o botão na tabela e adiciona a função de abrir o modal
                $('#tabelaTotalPorAno_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
                $('#tabelaTotalPorAno_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

                $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
                $('#buttonExcel').prop('title', 'Exportar')

                $('#buttonColVis').on('click', async function () {
                    $.LoadingOverlay('show');
                    $('#modal-ColunasVisiveis').modal('show');
                    $.LoadingOverlay('hide');
                });

                $('#buttonExcel').on('click', async function () {
                    const url = '/sisplan/impressao/v1/totalporano?';
                    const params = await retornaFiltros();
                    await exportaCSV(url, params, false, null, 'Relatório de Total por Ano', '#tabelaTotalPorAno');
                })

                $('#tabelaTotalPorAno').DataTable().columns().every(
                    function () {
                        if ((colunasInvisiveis.totalporano).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    }
                );

                const dados = jsonStr.map((key) => {
                    return { ...key, MES: `${retornaNomeMes(key.MES)}`, VALOR: parseFloat(key.VALOR), QUANTIDADE: key.QTDE, QUANTIDADE_VENDAS: key.QTDE_VEN, }
                })

                Graficos.criarGrafico({
                    container: 'graficoRelTotalPorAno',
                    tipo: 'column',
                    dados: dados,
                    colunasAgrupamento: ['MES'],
                    colunasValor: ['VALOR', 'QUANTIDADE', 'QUANTIDADE_VENDAS'],
                    seriesAgrupadas: true,
                    ordenacao: ["JANEIRO", "FEVEREIRO", "MARÇO", "ABRIL", "MAIO", "JUNHO", "JULHO", "AGOSTO", "SETEMBRO", "OUTUBRO", "NOVEMBRO", "DEZEMBRO"],
                })
            } catch (error) {
                console.error(error);
            }

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-filtros').modal('hide');
        }
    });

    retornaHintRelatorio('btnImprimir', 'TotalPorAnoPadrao')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let url = `/sisplan/impressao/v1/totalporano?`;
                const filtros = await retornaFiltros();

                if ($('#txtPeriodoDe').val() == '' || $('#txtPeriodoAte').val() == '') {
                    msgAlerta('Período não informado!');
                    return;
                }

                let arquivo = await GeraRelatorio(`${url + filtros}&`, 'POST', 100000, false);
                if (arquivo != undefined) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaTotalPorAno').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.totalporano ?? [])
    });

    function retornaNomeMes(mes) {
        let nomeMes = '';

        switch (parseInt(mes)) {
            case 1:
                nomeMes = 'JANEIRO'
                break;
            case 2:
                nomeMes = 'FEVEREIRO'
                break;
            case 3:
                nomeMes = 'MARÇO'
                break;
            case 4:
                nomeMes = 'ABRIL'
                break;
            case 5:
                nomeMes = 'MAIO'
                break;
            case 6:
                nomeMes = 'JUNHO'
                break;
            case 7:
                nomeMes = 'JULHO'
                break;
            case 8:
                nomeMes = 'AGOSTO'
                break;
            case 9:
                nomeMes = 'SETEMBRO'
                break;
            case 10:
                nomeMes = 'OUTUBRO'
                break;
            case 11:
                nomeMes = 'NOVEMBRO'
                break;
            case 12:
                nomeMes = 'DEZEMBRO'
                break;
            default:
                break;
        }

        return nomeMes
    };

    async function retornaFiltros() {
        const periodoDe = $('#txtPeriodoDe').val();
        const periodoAte = $('#txtPeriodoAte').val();
        const colecao = await formataListas($('#txtColecao').val().toString());
        const marca = await formataListas($('#txtMarca').val().toString());
        const vendedor = await formataListas($('#txtVendedor').val().toString());
        const grupocli = await formataListas($('#txtGrupoCli').val().toString());
        const cliente = await formataListas($('#txtEntidade').val().toString());
        const grupoprod = await formataListas($('#txtGrupoPA').val().toString());
        const etiqueta = await formataListas($('#txtEtiqueta').val().toString());
        const produto = await formataListas($('#txtProduto').val().toString());
        const linhaprod = await formataListas($('#txtLinha').val().toString());
        const cor = await formataListas($('#txtCor').val().toString());
        let empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')];
        const modelo = await formataListas($('#txtModelo').val().toString());

        empresas = empresas.join(',');
        const emitido = $('#cbEmitido').prop('checked');
        const pendente = $('#cbPendente').prop('checked');
        const agrupado = $('#cbAgrupado').prop('checked');
        const devolvido = $('#cbDevolvido').prop('checked');
        const cancelado = $('#cbCancelado').prop('checked');
        const tipo = $('#rdProduto').prop('checked') == true ? 'P' : 'M';
        const material = await formataListas($('#txtMaterial').val().toString());
        const grupoma = await formataListas($('#txtGrupoMA').val().toString());
        const tipovenda = await formataListas($('#txtTipoVenda').val().toString());

        return `PERIODODE=${periodoDe}&` +
            `PERIODOATE=${periodoAte}&` +
            `TIPO=${tipo}&` +
            `MATERIAL=${material}&` +
            `GRUPOMA=${grupoma}&` +
            `COLECAO=${colecao}&` +
            `MARCA=${marca}&` +
            `VENDEDOR=${vendedor}&` +
            `GRUPOCLI=${grupocli}&` +
            `CLIENTE=${cliente}&` +
            `GRUPOPROD=${grupoprod}&` +
            `ETIQUETA=${etiqueta}&` +
            `PRODUTO=${produto}&` +
            `LINHAPROD=${linhaprod}&` +
            `COR=${cor}&` +
            `EMPRESAS=${empresas}&` +
            `MODELO=${modelo}&` +
            `EMITIDO=${emitido}&` +
            `PENDENTE=${pendente}&` +
            `AGRUPADO=${agrupado}&` +
            `DEVOLVIDO=${devolvido}&` +
            `CANCELADO=${cancelado}&` +
            `TIPO_VENDA=${tipovenda}`;
    };

    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    $('#tutorial').on('click', function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btnFiltros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os filtros padrões da tela.',
                position: 'right'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Botão Imprimir',
                description: 'Clique aqui para Imprimir um relatório.',
                position: 'right'
            }
        },
        {
            element: '#tabelaRelDesempenhoProduto',
            popover: {
                title: 'Tabela',
                description: 'Aqui estão os dados dos produtos Filtrados.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });

    function limpaFiltros() {
        $('#txtVendedor').empty().trigger('change');
        $('#txtGrupoCli').empty().trigger('change');
        $('#txtEntidade').empty().trigger('change');
        $('#txtProduto').empty().trigger('change');
        $('#txtCor').empty().trigger('change');
        $('#txtGrupoPA').empty().trigger('change');
        $('#txtColecao').empty().trigger('change');
        $('#txtEtiqueta').empty().trigger('change');
        $('#txtLinha').empty().trigger('change');
        $('#txtMarca').empty().trigger('change');

        $('#txtPeriodoDe').val('1200-01-01');
        $('#txtPeriodoAte').val('2500-12-31');
    }

    adicionarConteudoModal(
        'Total por Ano', [
        {
            tipo: 'paragrafo',
            valor: 'Com base em uma visualização única, este relatório é essencial para analisar diversos pontos. ' +
                'Como por exemplo, Ticket Médio, Peças por Atendimento, Preço Médio, Quantidade de peças Vendidas e também de Vendas, sendo possível analisar anualmente e mensalmente. ' +
                'Como sugestão de uso, para melhor entendimento, empresas que possuem mais lojas o ideal é consultar apenas 1 por vez ou um determinado grupo de produto ' +
                'que possa estar presente também no estoque das demais, para não haver distorção nos dados. '
        },
        {
            tipo: 'paragrafo',
            valor: 'Quantas referências de determinada COR, de determinado GRUPO, o vendedor X vendeu no ano? (já com visão mensal e anual).',
        },
        {
            tipo: 'paragrafo',
            valor: 'Lembrando que o limite máximo da consulta para análise é o período de 12 meses (1 ano).'

        }
    ]
    );

});