class Metas {
  constructor(tipo, descricao, dtInicio, dtFinal, id, idValor) {
    this.tipo = tipo;
    this.descricao = descricao;
    this.dt_Inicio = dtInicio;
    this.dt_Final = dtFinal;
    this.id = id;
    this.idValor = idValor;

    this.url = '/sisplan/metas/v1/metas?';
  }

  validar() {
    const campos = [
      { valor: this.tipo, mensagem: 'Campo tipo não informado!' },
      { valor: this.descricao, mensagem: 'Campo descrição não informado!' },
      { valor: this.dt_Inicio, mensagem: 'Campo Data Inicial não informada!' },
      { valor: this.dt_Final, mensagem: 'Campo Data Final não informada!' }
    ];

    for (const campo of campos) {
      if (!campo.valor) {
        msgAlerta(campo.mensagem);
        return false;
      }
    }

    return true;
  }

  getBotaoDropdown(label, botoes) {
    const botoesHTML = botoes.map(({ classe, titulo, texto }) =>
      `<button class="dropdown-item ${classe}" type="button" title="${titulo}">${texto}</button>`
    ).join('');

    return `
      <div style="text-align:start;">
        <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
          ${label}
        </button>
        <div class="dropdown-menu">
          ${botoesHTML}
        </div>
      </div>
    `;
  }

  retornaBotaoOpcoes(data) {
    return this.getBotaoDropdown(data, [
      { classe: '', titulo: 'Excluir', texto: 'Excluir', classe: 'btnExcluirItemOpcoesMeta' }
    ]);
  }

  retornaBotaoOpcoesMeta(data) {
    return this.getBotaoDropdown(data, [
      { classe: 'btnMostraDias', titulo: 'Ver Dias', texto: 'Ver Dias' },
      { classe: 'btnEditarOpcoesMeta', titulo: 'Editar', texto: 'Editar' },
      { classe: 'btnExcluirOpcoesMeta', titulo: 'Excluir', texto: 'Excluir' }
    ]);
  }

  async carregaDias() {
    const whereClause = `DATA >= '${this.dt_Inicio.substring(0, 10)}' AND DATA <= '${this.dt_Final.substring(0, 10)}'`;
    const dados = {
      tabela: 'ANO',
      camposSelect: ['DIA_SEMANA', 'DATA', 'DIA_UTIL'],
      where: [whereClause],
      orderBy: ['DATA']
    };

    const sDados = await retornaJsonPesquisaPadrao(JSON.stringify(dados));
    if (!sDados || !sDados.length) return;

    const columns = [
      {
        data: 'SEL',
        width: '15px',
        render: (_, __, ___, meta) => `
          <div class="icheck-primary d-inline">
            <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" checked class="campoSel">
            <label for="check_col_${meta.row}_row_${meta.col}"></label>
          </div>
        `
      },
      ...Object.keys(sDados[0]).map(key => ({ data: key }))
    ];

    criaDataTablePadrao('#tabelaDiasMeta', false, false, false, false, true, false, '400px', sDados, columns, [], [2]);

    $('.campoSel').on('click', function () {
      $(this).toggleClass('selecionado', this.checked);
    });
  }

  preencheMeta() {
    $('#txtDescricaoMeta').val(this.descricao);
    $('#txtDtInicial').val(this.dt_Inicio);
    $('#txtDtFinal').val(this.dt_Final);
    $('#txtSelectTipos').val(this.tipo).prop('disabled', true);
  }

  async carregaValoresMeta() {
    const idMeta = this.id > 0 ? this.id : this._extrairIdDaUrl();
    if (!idMeta) return;

    $('#txtIdMeta').val(idMeta);
    const response = await requisicao('GET', this.url, `ID=${idMeta}`);
    if (!response) return;

    const metas = await response.json();
    if (response.status !== 200 || !metas.length) {
      $('#txtSelectTipos').trigger('change');
      return;
    }

    this.id = metas[0].ID;
    this.descricao = metas[0].DESCRICAO;
    this.dt_Inicio = metas[0].DT_INICIO;
    this.dt_Final = metas[0].DT_FINAL;
    this.tipo = metas[0].TIPO;

    this.preencheMeta();
    this.retornaValoresMetas();
    this.carregaDias();

    $(`#${this.tipo}Metas`).removeClass('d-none');
    $('#buttonsOpcoesMetas').removeClass('divButtons');

    if (this.tipo === 'CLIENTE') {
      $('.divClassificacaoCliente').removeClass('d-none');
      $('#buttonsOpcoesMetas').addClass('divButtons');

    }

    $('#txtSelectTipos').trigger('change');
  }

  async retornaValoresMetas() {
    const dadosSelect = {
      tabela: 'METAVALORES',
      camposSelect: ['ID', 'OPERACAO', 'VALOR'],
      where: [`ID_META = ${this.id}`],
      orderby: ['ID']
    };

    const json = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!json || !json.length) return;

    this._montaTabelaValores(json);
  }

  _montaTabelaValores(json) {
    if ($.fn.DataTable.isDataTable('#tabelaValoresMetas')) {
      $('#tabelaValoresMetas').DataTable().destroy();
      $('#tabelaValoresMetas').empty();
    }

    const columns = Object.keys(json[0]).map(k => ({ title: k, data: k }));
    const botaoDinamico = {
      targets: [0],
      funcao: (data) => this.retornaBotaoOpcoesMeta(data)
    };

    criaDataTablePadrao('#tabelaValoresMetas', false, false, false, false, false, false, '150px', json, columns, [], [], [], [2], botaoDinamico);

    $('#tabelaValoresMetas')
      .on('click', '.btnEditarOpcoesMeta', (e) => {
        const dados = this._getRowData(e.target);
        const item = $('#tabelaItensValoresMetas').DataTable().rows().data().toArray();
        new OpcoesMetas(dados.VALOR, dados.OPERACAO, item[0]?.PERCENTUAL_COM, item, this.id, dados.ID).iniciaEdicao();
      })
      .on('click', '.btnMostraDias', (e) => {
        const dados = this._getRowData(e.target);
        new OpcoesMetas(dados.VALOR, dados.OPERACAO, [], [], this.id, dados.ID).buscaDiasMeta();
      }).on('click', '.btnExcluirOpcoesMeta', (e) => {
        const dados = this._getRowData(e.target);
        const opcoes = new OpcoesMetas(dados.VALOR, dados.OPERACAO, [], [], this.id, dados.ID);
        opcoes.deletarOpcoes();

        this.carregaValoresMeta()
      })
      .on('click', 'tr', (e) => {
        const row = $(e.currentTarget);
        if (row.hasClass('selected')) return;

        $('#tabelaValoresMetas').DataTable().$('tr.selected').removeClass('selected');
        row.addClass('selected');

        const data = $('#tabelaValoresMetas').DataTable().row(row).data();
        new Metas(this.tipo, this.descricao, this.dt_Inicio, this.dt_Final, this.id, data.ID).retornaItensValoresMetas();
      });

    $($('#tabelaValoresMetas tr')[1]).trigger('click');
  }

  async retornaItensValoresMetas() {
    const json = await this.buscarValoresMetas();
    if (!json) return;

    if ($.fn.DataTable.isDataTable('#tabelaItensValoresMetas')) {
      $('#tabelaItensValoresMetas').DataTable().destroy();
      $('#tabelaItensValoresMetas').empty();
    }

    const columns = Object.keys(json[0]).map(k => ({ title: k, data: k }));
    const botaoDinamico = {
      targets: [0],
      funcao: (data) => this.retornaBotaoOpcoes(data)
    };

    criaDataTablePadrao('#tabelaItensValoresMetas', false, true, false, true, false, false, '150px', json, columns, [], [], [], [2, 3], botaoDinamico, 2);


    $('#tabelaItensValoresMetas')
      .on('click', '.btnExcluirItemOpcoesMeta', async (e) => {

        await this.excluirItem();

      })

    $($('#tabelaItensValoresMetas_wrapper .col-sm-12')[0]).html('<h5 class="d-flex align-items-end" style="height: 100%;">Itens Valores</h5>');
  }

  async buscarValoresMetas() {
    const response = await requisicao('GET', '/sisplan/metas/v1/opcoes?', `ID=${this.idValor}&TIPO=${this.tipo}`, '', 150000);
    if (!response) return;

    const json = await response.json();
    if (response.status !== 200) {
      msgErro(json.mensagem);
      return null;
    }

    return json;
  }

  async gravar() {
    const response = await requisicao('POST', this.url, '', JSON.stringify(this));
    if (!response) return;

    const json = await response.json();
    if (response.status !== 200) {
      msgErro(json.mensagem);
      return;
    }
    this.id = json;
    $('#txtIdMeta').val(json)
    this.carregaValoresMeta()
  }

  async deletar() {
    const response = await requisicao('DELETE', this.url, `ID=${this.id}`, '', 15000);
    if (!response) return;

    if (response.status !== 200) {
      const json = await response.json();
      msgErro(json.mensagem);
      return;
    }

    this.buscar();
    criaMensagemSucesso('Meta deletada com sucesso!');
  }

  async excluirItem() {
    const data = $('#tabelaValoresMetas').DataTable().row($('tr.selected')).data();
    const dados = this._getRowDataItem(event.target);
    const response = await requisicao('DELETE', '/sisplan/metas/v1/item?', `ID_VALOR=${data.ID}&ITEM=${dados.CODIGO}`, '', 15000);
    if (!response) return;

    if (response.status !== 200) {
      const json = await response.json();
      msgErro(json.mensagem);
      return;
    }

    criaMensagemSucesso('Item excluido com sucesso!', () =>
      this.carregaValoresMeta()
    );
  }

  async adicionarClientesClassificacao() {
    const response = await requisicao('GET', '/sisplan/metas/v1/clientesclassificacao?', `CLASSIFICACAO=${$('#txtClassificacaoCliente').val()}`, '', 60000);
    const json = await response.json();

    if (!response) {
      msgErro(json.mensagem);
      return;
    }

    $('#txtCliente').empty().trigger('change');
    await insereValorPesquisaVarios('txtCliente', 'CODCLI', 'NOME', json);
  }

  _extrairIdDaUrl() {
    const partes = window.location.href.split('/');
    const id = partes[partes.length - 1];
    return parseInt(id) || null;
  }

  _getRowData(el) {
    return $('#tabelaValoresMetas').DataTable().row($(el).parents('tr')).data();
  }
  _getRowDataItem(el) {
    return $('#tabelaItensValoresMetas').DataTable().row($(el).parents('tr')).data();
  }
}
