<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Motorista</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.256.25.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.256.25.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.256.25.1" />
  <link href='../dist/css/bootstrap.min.css?versao=3.256.25.1'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.256.25.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.256.25.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.256.25.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.256.25.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.256.25.1">
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.256.25.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.256.25.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.256.25.1">
  <style>
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 50%;
      float: left;
      position: relative
    }

    .labelGeral {
      margin-top: 7px;
      margin-bottom: 3px;
    }

    .labelCheck {
      font-size: 120%;
      padding: 0.2%;
      margin-left: 1%;
    }

    .configCheck {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
      padding: 10px;
    }

    .radioTipo {
      font-size: 120%;
    }

    .frete {
      margin-top: 2%;
      margin-left: 0.1%;
    }

    .checkboxOpcoes {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 1.6%;
      padding-bottom: 0%;
    }

    .labelTipo {
      margin-bottom: 3px;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 0 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }

    #tabelaEmpresa td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaEmpresa td {
      padding: 0 !important;
      padding-left: 10px !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">


    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>

    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
              </div>
              <div class="col-sm-6">
              </div><!-- /.col -->
            </div><!-- /.row -->
          </div>
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Cadastro de Motorista
                    <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>
                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <!-- progressbar -->
                      <ul id="progressbar">
                        <li class="active" id="account" style="font-size: 100%;"><strong>Geral</strong></li>
                        <li id="payment" style="font-size: 100%;"><strong>Configurações</strong></li>
                      </ul> <!-- fieldsets -->
                      <p>Preencha os dados e clique em avançar para realizar o cadastro do motorista</p>

                      <fieldset>
                        <div class="form-card" id="formcard1">
                          <h2 class="fs-title">Dados Gerais</h2>
                          <div class="row">
                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código *</label>
                              <input type="number" readonly class="input-default focus form-control" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Campo preenchido automaticamente">
                            </div>
                            <div class="col-lg-8  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtNome">Nome *</label>
                              <input type="text" class="input-default focus form-control" id="txtNome" required aria-describedby="descError" name="txtNome" class="form-control" placeholder="Nome">
                            </div>
                            <div class="mt-4 pt-3">
                              <div class="icheck-primary">
                                <input class="ml-2" type="checkbox" checked id="checkAtivo">
                                <label class='' for="checkAtivo">Ativo</label>
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-lg-3 col-12 form-group" id="cnpjTour">
                              <label>CNPJ/CPF *</label>
                              <input type="text" class="input-default focus form-control validate" required id="txtCNPJ" name="txtCNPJ" placeholder="CNPJ ou CPF">
                            </div>
                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtRG">RG *</label>
                              <div class="input-group">
                                <input type="text" required class="input-default focus form-control" id="txtRG" name="txtRG" class="form-control" placeholder="RG">
                              </div>
                            </div>
                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCNH">CNH *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCNH" required aria-describedby="classeError" name="txtCNH" class="form-control" placeholder="CNH">
                              </div>
                            </div>
                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="dtValidadeCNH">Validade CNH</label>
                              <div class="input-group">
                                <input type="date" class="input-default focus form-control" id="dtValidadeCNH" name="dtValidadeCNH" class="form-control">
                              </div>
                            </div>
                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtTelefone">Telefone</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtTelefone" name="txtTelefone" class="form-control" placeholder="Telefone">
                              </div>
                            </div>
                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="dtValidadeTox">Val. Exame Tóx.</label>
                              <div class="input-group">
                                <input type="date" class="input-default focus form-control" id="dtValidadeTox" name="dtValidadeTox" class="form-control">
                              </div>
                            </div>
                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtNextel">Nextel</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtNextel" name="txtNextel" class="form-control" placeholder="Nexttel">
                              </div>
                            </div>
                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCelular">Celular</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCelular" name="txtCelular" class="form-control" placeholder="Celular">
                              </div>
                            </div>
                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCep">CEP</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCep" name="txtCep" class="form-control" placeholder="CEP">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnCep" name="btnCep" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnLimpaCep" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-6 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtRua">Rua: </label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtRua" name="txtRua" class="form-control" placeholder="Rua">
                              </div>
                            </div>
                            <div class="col-lg-1 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtEstado">UF: </label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtEstado" name="txtEstado" class="form-control" placeholder="UF">
                              </div>
                            </div>
                            <div class="col-lg-2 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtNumero">Nº</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtNumero" name="txtNumero" class="form-control" placeholder="Nº">
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-lg-6  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtReferencia1">Referência 1:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtReferencia1" name="txtReferencia1" class="form-control" placeholder="Referência 1">
                              </div>
                            </div>
                            <div class="col-lg-6  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtReferencia2">Referência 2:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtReferencia2" name="txtReferencia2" class="form-control" placeholder="Referência 2">
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="avancar1" class="btn-sisp next action-button" value="Avançar" id="avancar1" />
                        <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                      </fieldset>
                      <fieldset>
                        <div class="form-card" id="formcard1">
                          <h2 class="fs-title">Configurações</h2>
                          <div class="row">
                            <div class="col-sm-8">
                              <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtAddTransportadora">Transportadora:</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtAddTransportadora" name="txtAddTransportadora" class="form-control" placeholder="Transportadora">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnAddTransportadora" name="btnAddTransportadora" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaTransportadora" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <div class="col-sm-4 mt-3" style="margin-top:5px">
                              <button id="btnAdicionarTransportadora" type="button" class="btn btn-primary btn-block mt-2">
                                Adicionar Transportadora
                              </button>
                            </div>
                          </div>
                          <div class="col-sm-12 mt-3 pb-4 table-responsive card-body">
                            <table id="tabelaTransportadora" class="table table-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                  <th>Ação</th>
                                  <th>Nome</th>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>
                        <input type="button" name="gravar" class="action-button" value="Gravar" id="gravar">
                        <input type="button" name="voltar2" class="previous action-button-previous" value="Voltar" id="voltar2" />
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>
</body>

<?php
include_once('../../../modais.php');
?>

<aside class="control-sidebar control-sidebar-dark">
</aside>
</div>

<script src="../plugins/jquery/jquery.min.js?versao=3.256.25.1"></script>
<script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.256.25.1"></script>
<script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.256.25.1"></script>
<script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.256.25.1"></script>
<script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.256.25.1"></script>
<script src="../plugins/toastr/toastr.min.js?versao=3.256.25.1"></script>
<script>
  $.widget.bridge('uibutton', $.ui.button);
</script>
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.256.25.1"></script>
<script src="../dist/js/adminlte.min.js?versao=3.256.25.1"></script>
<script src="../dist/js/requisicoes.js?versao=3.256.25.1"></script>
<script src="../dist/js/cliente/entidade.js?versao=3.256.25.1"></script>
<script src="../dist/js/loadingoverlay.min.js?versao=3.256.25.1"></script>
<script src="../dist/js/valida_cpf_cnpj.js?versao=3.256.25.1"></script>
<script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.256.25.1"></script>
<script src="../dist/js/sisplan.js?versao=3.256.25.1"></script>
<script src="../utils/funcoes.js?versao=3.256.25.1"></script>
<script src="../utils/cookies.js?versao=3.256.25.1"></script>
<script src="../dist/js/jquery.mask.min.js?versao=3.256.25.1"></script>
<script src="../dist/js/jquery.maskMoney.min.js?versao=3.256.25.1"></script>
<script src="../dist/js/driver.min.js?versao=3.256.25.1"></script>
<script src="../dist/js/dataTables.keyTable2.js?versao=3.256.25.1"></script>
<script type="text/javascript" src="../config.js?versao=3.256.25.1"></script>
<script>
  $(document).ready(async function() {
    if (getCookie('usuario') == "") {
      window.location.href = `${BASE_URI}/login`;
      return;
    }

    let usuario = getCookie('usuario');
    let empresa = getCookie('empresa');

    ipInterno = IP_INTERNO;
    ipExterno = IP_EXTERNO;
    basicAuth = BASIC_AUTH;

    const temAcesso = await temAcessoTela('CADMOTORISTA');
    if (!temAcesso.resultado) {
      toastrAcesso(temAcesso, BASE_URI);
      return;
    }

    const permissaoUsuarioLogado = await permissaoAcessos("CADMOTORISTA");

    if (permissaoUsuarioLogado.INCLUI == 'N') {
      await criaMensagemErro("Sem permissão para incluir!", () => {
        window.location.href = `${BASE_URI}/cadmotorista`
      });
      return;
    }

    const queryString = window.location.href;
    const parametros = queryString.split("/");
    const motorista = parametros[parametros.length - 1];

    $(window).on("beforeunload", function(e) {
      e.stopPropagation();
      deletaRegistro("CADMOTORISTA", getCookie("usuario"), motorista);
      return undefined;
    });

    sArquivo = `${BASE_URI}/pages/cadmotorista/cadastro_cadmotorista/cadmotorista.js?versao=3.256.25.1`;
    insereJavaScriptPagina(sArquivo);

    const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
    habilitaCamposObrigatoriosTela(nomeTela);
  });
</script>
</body>

</html>