$(document).ready(async function () {

  async function getAllUsers() {
    // <option value="WY">Wyoming</option>
    try {
      try {
        const pesquisa = {
          tabela: 'ACESSO_USUARIOS',
          camposSelect: ['CODIGO', 'NOME'],
          where: [`CODIGO <> '9999'`]
        }
        const url = `/sisplan/funcoes/v1/pesquisa?JSON=${JSON.stringify(pesquisa)}`;
        const response = await requisicao('GET', '', url, null, 20000);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          msgErro(result['RESULT'][0].mensagem);
          return;
        }

        const result = await response.json();
        if (result['RESULT'][0]) {
          const dados = result['RESULT'][0];
          const arrUsuarios = dados.map(dado => {
            return `<option value="${dado.CODIGO}">${dado.NOME}</option>`;
          });
          // $('#txtNotificacaoDestino').append(`<option value=""></option>`);
          $('#txtNotificacaoDestino').append(arrUsuarios);

          $("#txtNotificacaoDestino").select2({
            multiple: true,
            allowClear: true,
            placeholder: $traducaoSelecioneOsRegistros[['I', 'E', 'M'].includes(getCookie('idiomaUsuario')) ? getCookie('idiomaUsuario') : 'P']
          });
          $('#txtNotificacaoDestino').val(null).trigger('change');
        }
      } catch (error) {
        msgErro('Erro ao buscar usuários');
        return;
      }
    } finally {

    }

  }

  async function getUnreadNotifications() {
    try {
      try {
        const codUsuario = getCookie('cod_usuario');
        const pesquisa = {
          tabela: 'NOTIFICACAOWEB',
          camposSelect: ['ID', 'DESCRICAO', 'DT_CADASTRO', 'DT_LEITURA', 'LIDO', 'ORIGEM', 'TIPO'],
          where: [`USUARIO_DESTINO = '${codUsuario}' AND LIDO='N'`]
        }
        const url = `/sisplan/funcoes/v1/pesquisa?JSON=${JSON.stringify(pesquisa)}&REPLACE_LINE_BREAK=S`;
        const response = await requisicao('GET', '', url, null, 20000);

        if (!response) {
          return;
        }

        const result = await response.json();
        if (response.status != 200) {
          msgErro(result['RESULT'][0].mensagem);
          return;
        }

        if (result['RESULT'][0]) {
          const dados = result['RESULT'][0];
          const conteudo = dados.map((notificacao => {
            const dataFormatada = new Intl.DateTimeFormat('default', {
              year: 'numeric', month: 'numeric', day: 'numeric',
              hour: 'numeric', minute: 'numeric', second: 'numeric',
              hour12: false
            }).format(new Date(notificacao.DT_CADASTRO));
            return (
              `<div class="dropdown-divider"></div>` +
              ` <a style="width: 100%; display: flex;align-items: center;justify-content: flex-start;grid-gap:1rem" data-id="${notificacao.ID}" href="#" class="dropdown-item notificacao">` +
              `  <i class="fas fa-exclamation-triangle"></i> <span class="text-sm">${notificacao.DESCRICAO.substring(0, 50)+'...'}</span>` +
              `  <span class="float-right text-muted text-sm">${dataFormatada}</span>` +
              `</a>`
            ).replaceAll(',', '|');
          })).toString().replaceAll(',', '').replaceAll('|', ',');

          $('#div_notificacoes').html(
            `<div class="flex align-items-center"><span class="dropdown-item dropdown-header">Notificações</span><button id="btnAddNotificacao" class="btn btn-danger btn-xs"><i class="fas fa-plus"></i></button></div>` +
            `${conteudo}` +
            `<div class="dropdown-divider"></div>`
          );

          $('.notificacao').on('click', async function () {
            $('#txtNotificacaoId').val($(this).attr('data-id'));
            const dados = await getNotificationInfo($(this).attr('data-id'));
            $('#divNotificacaoDestino').addClass('d-none');
            $('#txtNotificacaoDesc').attr('disabled', true).attr('readonly', true).val('');
            $('#txtNotificacaoDestino').val(null).trigger('change');
            adicionaEventoConfirmarNotificacao();
            $('#txtNotificacaoData').val(dados.DT_CADASTRO);
            $('#txtNotificacaoOrigem').val(dados.ORIGEM);
            $('#txtNotificacaoDesc').val(dados.DESCRICAO);
            $('#modalNotificacao').modal('show');
          });


        } else {
          $('#div_notificacoes').html(
            `<div class="flex align-items-center"><span class="dropdown-item dropdown-header">Notificações</span><button id="btnAddNotificacao" class="btn btn-danger btn-xs"><i class="fas fa-plus"></i></button><div>` +
            `<div class="dropdown-divider"></div>`
          );
        }

        $('#btnAddNotificacao').on('click', function () {
          const usuario = getCookie('usuario');
          const today = new Date();//.toISOString().split('T')[0];
          today.setTime(today.getTime() - (3 * 60 * 60 * 1000));
          const dataFormatada = today.toISOString().split('T')[0];
          const horaFormatada = today.toISOString().split('T')[1].substring(0, 5);
          $('#txtNotificacaoData').val(dataFormatada + ' ' + horaFormatada);
          $('#txtNotificacaoOrigem').val(usuario);
          $('#txtNotificacaoDesc').attr('disabled', false).attr('readonly', false).val('');
          $('#modalNotificacao').modal('show');
          $('#divNotificacaoDestino').removeClass('d-none');
          $('#btnConfirmarNotificacao').off('click');
          $('#btnConfirmarNotificacao').on('click', async function () {
            const destinos = $('#txtNotificacaoDestino').val();
            const descricao = $('#txtNotificacaoDesc').val();
            if (destinos.length == 0) {
              msgErro('Necessário informar um destino válido.');
              return;
            }

            if (descricao == '') {
              msgErro('Necessário informar uma descrição.');
              return;
            }

            await saveNotification(descricao, destinos, 'Usuario', getCookie('usuario'));
            await toastr
              .success('Notificação criada com sucesso.', "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                  error: "alert-error",
                  info: "alert-info",
                  success: "alert-success",
                  warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                async onHidden() {
                  getNumberOfUnreadNotifications();
                  $('#botao_notificacoes').trigger('click');
                  $('#modalNotificacao').modal('hide');
                },
              })
              .css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
              });
          });

          $('#txtNotificacaoDesc').focus();
        });


      } catch (error) {
        $('#div_notificacoes').html(
          `<div class="flex align-items-center"><span class="dropdown-item dropdown-header">Notificações</span><button id="btnAddNotificacao" class="btn btn-danger btn-xs"><i class="fas fa-plus"></i></button><div>` +
          `<div class="dropdown-divider"></div>`
        );
      }
    } finally {
      if (!$('#botao_notificacoes').parent().hasClass('show')) {
        $('#botao_notificacoes').parent().addClass('show');
        $('#div_notificacoes').addClass('show');
        $('#div_notificacoes').css('display', 'flex');
      }
    }
  }


  async function getNumberOfUnreadNotifications() {
    try {
      const codUsuario = getCookie('cod_usuario');
      const pesquisa = {
        tabela: 'NOTIFICACAOWEB',
        camposSelect: ['COUNT(*) QUANTIDADE'],
        where: [`USUARIO_DESTINO = '${codUsuario}' AND LIDO = 'N'`]
      }
      const url = `/sisplan/funcoes/v1/pesquisa?JSON=${JSON.stringify(pesquisa)}`;
      const response = await requisicao('GET', '', url, null, 20000);

      if (!response) {
        return;
      }

      const result = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr['RESULT'][0].mensagem);
        return;
      }

      if (result['RESULT'][0][0].QUANTIDADE) {
        $('#numero_notificacoes').html(result['RESULT'][0][0].QUANTIDADE);
      } else {
        $('#numero_notificacoes').html(0);
      }
    } catch (error) {
      $('#numero_notificacoes').html(0);
    }
  }

  async function getNotificationInfo(id) {
    try {
      const pesquisa = {
        tabela: 'NOTIFICACAOWEB',
        camposSelect: ['DESCRICAO', 'DT_CADASTRO', 'DT_LEITURA', 'LIDO', 'ORIGEM', 'TIPO'],
        where: [`ID = '${id}'`]
      }
      const url = `/sisplan/funcoes/v1/pesquisa?JSON=${JSON.stringify(pesquisa)}`;
      const response = await requisicao('GET', '', url, null, 20000);

      if (!response) {
        return;
      }

      const result = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr['RESULT'][0].mensagem);
        return;
      }

      return result['RESULT'][0][0];
    } catch (error) {
      console.error(error);
    }
  }

  async function saveNotification(descricao, usuario_destino, tipo, origem) {
    const url = `/sisplan/notificacaoweb/v1/salvar?`;
    try {
      try {
        $.LoadingOverlay("show");
        for (let i = 0; i < usuario_destino.length; i++) {
          const usuario = usuario_destino[i];
          const objeto = {
            descricao: descricao,
            usuarioDestino: usuario,
            tipo: tipo,
            origem: origem,
            lido: 'N',
            dt_cadastro: `${formataData(new Date())}T00:00:00Z`
          }
          const response = await requisicao("POST", url, "", encodeURIComponent(JSON.stringify(objeto)), 120000);

          if (!response) {
            msgErro("Não foi possível salvar a notificação.");
            return;
          }

          // let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro("Não foi possível salvar a notificação.");
            return;
          }
        }
      } catch (error) {
        console.error(error);
        msgErro("Não foi possível salvar a notificação.");
        return;
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function setNotificationAsRead(id) {
    const url = `/sisplan/notificacaoweb/v1/setarcomolida?`;
    try {
      try {
        $.LoadingOverlay("show");

        const response = await requisicao("POST", url, `id=${id}`, null, 120000);

        if (!response) {
          msgErro("Não foi possível setar a notificação como lida.");
          return;
        }

        // let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro("Não foi possível setar a notificação como lida.");
          return;
        }
      } catch (error) {
        console.error(error);
        msgErro("Não foi possível setar a notificação como lida.");
        return;
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  await getNumberOfUnreadNotifications();

  $('#botao_notificacoes').on('click', async function () {
    await getAllUsers();
    const dropdownAtivo = $('#botao_notificacoes').parent().hasClass('show');
    if (!dropdownAtivo) {
      await getUnreadNotifications();
    } else {
      $('#botao_notificacoes').parent().removeClass('show');
      $('#div_notificacoes').removeClass('show');
      $('#div_notificacoes').css('display', 'none');
    }
  });

  async function adicionaEventoConfirmarNotificacao() {
    $('#btnConfirmarNotificacao').off('click');
    $('#btnConfirmarNotificacao').on('click', async function () {
      const id = $('#txtNotificacaoId').val();
      await setNotificationAsRead(id);
      await toastr
        .success('Confirmado leitura da notificação', "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          async onHidden() {
            getNumberOfUnreadNotifications();
            $('#botao_notificacoes').trigger('click');
            $('#modalNotificacao').modal('hide');
          },
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
    });
  }
});